/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.builders;

import com.carrotsearch.hppc.IntIntHashMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.BitSet;
import java.util.TreeMap;
import morfologik.fsa.FSA;
import morfologik.fsa.FSA5;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.StateVisitor;

public final class FSAUtils {
    public static String toDot(FSA fsa, int node) {
        try {
            StringWriter w = new StringWriter();
            FSAUtils.toDot(w, fsa, node);
            return w.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void toDot(Writer w, FSA fsa, int node) throws IOException {
        w.write("digraph Automaton {\n");
        w.write("  rankdir = LR;\n");
        BitSet visited = new BitSet();
        w.write("  stop [shape=doublecircle,label=\"\"];\n");
        w.write("  initial [shape=plaintext,label=\"\"];\n");
        w.write("  initial -> " + node + "\n\n");
        FSAUtils.visitNode(w, 0, fsa, node, visited);
        w.write("}\n");
    }

    private static void visitNode(Writer w, int d, FSA fsa, int s, BitSet visited) throws IOException {
        visited.set(s);
        w.write("  ");
        w.write(Integer.toString(s));
        if (fsa.getFlags().contains((Object)FSAFlags.NUMBERS)) {
            int nodeNumber = fsa.getRightLanguageCount(s);
            w.write(" [shape=circle,label=\"" + nodeNumber + "\"];\n");
        } else {
            w.write(" [shape=circle,label=\"\"];\n");
        }
        int arc = fsa.getFirstArc(s);
        while (arc != 0) {
            w.write("  ");
            w.write(Integer.toString(s));
            w.write(" -> ");
            if (fsa.isArcTerminal(arc)) {
                w.write("stop");
            } else {
                w.write(Integer.toString(fsa.getEndNode(arc)));
            }
            byte label = fsa.getArcLabel(arc);
            w.write(" [label=\"");
            if (Character.isLetterOrDigit(label)) {
                w.write((char)label);
            } else {
                w.write("0x");
                w.write(Integer.toHexString(label & 0xFF));
            }
            w.write("\"");
            if (fsa.isArcFinal(arc)) {
                w.write(" arrowhead=\"tee\"");
            }
            if (fsa instanceof FSA5 && ((FSA5)fsa).isNextSet(arc)) {
                w.write(" color=\"blue\"");
            }
            w.write("]\n");
            arc = fsa.getNextArc(arc);
        }
        arc = fsa.getFirstArc(s);
        while (arc != 0) {
            int endNode;
            if (!fsa.isArcTerminal(arc) && !visited.get(endNode = fsa.getEndNode(arc))) {
                FSAUtils.visitNode(w, d + 1, fsa, endNode, visited);
            }
            arc = fsa.getNextArc(arc);
        }
    }

    public static TreeMap<Integer, Integer> calculateFanOuts(final FSA fsa, int root) {
        int high;
        final int[] result = new int[256];
        fsa.visitInPreOrder(new StateVisitor(){

            @Override
            public boolean accept(int state) {
                int count = 0;
                int arc = fsa.getFirstArc(state);
                while (arc != 0) {
                    ++count;
                    arc = fsa.getNextArc(arc);
                }
                int n = count;
                result[n] = result[n] + 1;
                return true;
            }
        });
        TreeMap<Integer, Integer> output = new TreeMap<Integer, Integer>();
        for (int low = 1; low < result.length && result[low] == 0; ++low) {
        }
        for (high = result.length - 1; high >= 0 && result[high] == 0; --high) {
        }
        for (int i = low; i <= high; ++i) {
            output.put(i, result[i]);
        }
        return output;
    }

    public static IntIntHashMap rightLanguageForAllStates(final FSA fsa) {
        final IntIntHashMap numbers = new IntIntHashMap();
        fsa.visitInPostOrder(new StateVisitor(){

            @Override
            public boolean accept(int state) {
                int thisNodeNumber = 0;
                int arc = fsa.getFirstArc(state);
                while (arc != 0) {
                    thisNodeNumber += (fsa.isArcFinal(arc) ? 1 : 0) + (fsa.isArcTerminal(arc) ? 0 : numbers.get(fsa.getEndNode(arc)));
                    arc = fsa.getNextArc(arc);
                }
                numbers.put(state, thisNodeNumber);
                return true;
            }
        });
        return numbers;
    }

    public static final class IntIntHolder {
        public int a;
        public int b;

        public IntIntHolder(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public IntIntHolder() {
        }
    }
}

